//----------------------------------------------------------------------------//
//- CadArtikel.pas -----------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Dialog zum Erfassen und bearbeiten von Artikeln.                           //
// Abgeleitet von CadBasisErfassen                                            //
//----------------------------------------------------------------------------//

unit CadArtikel;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBasisErfassen, StdCtrls, CafArtikel, ExtCtrls, CaoArtikelListe;

//------------------------------------------------------------------------------

type
  TCaDlgArtikel = class(TDlgBasisErfassen)

    //--------------------------------------------------------------------------

    m_GrpArtikel      : TGroupBox;
    m_FrmArtikelDaten : TFrmArtikeldaten;
    procedure FormCreate     (Sender: TObject);
    procedure FormDestroy    (Sender: TObject);
    procedure FormShow       (Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);

  //----------------------------------------------------------------------------

  private
    m_obArtikel: TCaoArtikel;

  //----------------------------------------------------------------------------

  protected
    procedure PrtSetTitles; override;

  //----------------------------------------------------------------------------

  public
    function ShowModal(obArtikel: TCaoArtikel): Integer; reintroduce;

  //----------------------------------------------------------------------------

  end; // TCaDlgArtikel

//------------------------------------------------------------------------------

var
  CaDlgArtikel: TCaDlgArtikel;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CamConst, CadEtikettenDrucken, CaoController;

//------------------------------------------------------------------------------

procedure TCaDlgArtikel.PrtSetTitles;
begin
  m_sTitelNeu        := c_sArtikelNeu;
  m_sTitelBearbeiten := c_sArtikelBearbeiten;
end; // TCaDlgArtikel.PrtSetTitles

//------------------------------------------------------------------------------

procedure TCaDlgArtikel.FormCreate(Sender: TObject);
begin
  inherited;
  m_FrmArtikelDaten.CreateFrame;
end; // TCaDlgArtikel.FormCreate

//------------------------------------------------------------------------------

procedure TCaDlgArtikel.FormDestroy(Sender: TObject);
begin
  m_FrmArtikelDaten.DestroyFrame;
  inherited;
end; // TCaDlgArtikel.FormDestroy

//------------------------------------------------------------------------------

procedure TCaDlgArtikel.FormShow(Sender: TObject);
begin
  inherited;
  m_FrmArtikelDaten.ShowFrame(m_obArtikel);
end; // TCaDlgArtikel.FormShow

//------------------------------------------------------------------------------

function TCaDlgArtikel.ShowModal(obArtikel: TCaoArtikel): Integer;
begin
  m_obArtikel := obArtikel;
  Result := inherited ShowModal(obArtikel.iStatus);
end; // TCaDlgArtikel.ShowModal

//------------------------------------------------------------------------------

procedure TCaDlgArtikel.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  inherited;
  if CanClose and (ModalResult <> mrCancel) then begin
    m_FrmArtikelDaten.CloseFrame;
  end; // if
end; // TCaDlgArtikel.FormCloseQuery

//------------------------------------------------------------------------------

end. // CadArtikel
